/* 
 *  JoinForm.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;

public class JoinForm {

    private final Stage join = new Stage();
    private final InteractionExecutor interactionExe;
    private static final Logger LOG = Logger.getLogger(JoinForm.class);
    public JoinForm(InteractionExecutor interactionExe, String css) {
        this.interactionExe = interactionExe;
        BorderPane joinBorder = new BorderPane();
        Scene joinScene = new Scene(joinBorder, 300, 400);
        joinScene.getStylesheets().add(css);
        join.setScene(joinScene);
        join.titleProperty().set("Join");
    }

    public void show() {
        join.show();
    }

    public void updateJoinForm(List<InteractionData> numbers, String interactionID) {
        BorderPane bp = (BorderPane) join.sceneProperty().get().getRoot();

        ListView<InteractionData> list = new ListView<>();
        ObservableList<InteractionData> items = FXCollections.observableArrayList(
                numbers);
        list.setItems(items);

        list.setCellFactory(new Callback<ListView<InteractionData>, ListCell<InteractionData>>() {
            @Override
            public ListCell<InteractionData> call(ListView<InteractionData> list) {
                return new JoinForm.CodeCell();
            }
        }
        );

        //Only enable the ok button when a selection is made
        Button joinButton = new Button("Join");
        joinButton.setDisable(true);

        list.getSelectionModel().selectedItemProperty().addListener(new ChangeListener<InteractionData>() {
            @Override
            public void changed(ObservableValue<? extends InteractionData> observable, InteractionData oldValue, InteractionData newValue) {
                if (newValue != null) {
                    joinButton.setDisable(false);
                }
            }
        }
        );

        bp.setCenter(list);
           
        joinButton.getStyleClass().add("interactionButton");
        joinButton.setOnAction((ActionEvent t) -> {
            LOG.info("JoinButton()");
            InteractionData selectedInteraction = list.getSelectionModel().getSelectedItem();
            interactionExe.join(interactionID, selectedInteraction.getId());
            join.close();
        });

        Button cancelButton = new Button("Cancel");
        cancelButton.getStyleClass().add("interactionButton");
        cancelButton.setOnAction((ActionEvent t) -> {
            LOG.info("CancelButton()");
            join.close();
        });


        HBox hbuttonbox = new HBox();
        hbuttonbox.getChildren().addAll(joinButton, cancelButton);
               
        VBox v = new VBox();        
        v.getChildren().addAll(hbuttonbox);
        bp.setBottom(v);
    }

    private static class CodeCell extends ListCell<InteractionData> {

        @Override
        public void updateItem(InteractionData item, boolean empty) {
            super.updateItem(item, empty);
            if (item != null) {
                setText(item.getContactID() );
            }
        }
    }
}
